<?php



class CombinationValue extends ObjectModel
{
	/** @var string Name */
	public $id_ns_caisseconfig;
		
	/** @var integer */
	public $combination_id;
	
	public $id_shop;
	
	/** @var integer */
	public $combination_value;
	
	public $encoded_value;
	
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'ns_caisseconfig',
        'primary' => 'id_ns_caisseconfig',
        'multilang' => FALSE,
        'fields' => array(
            'combination_id' => array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => TRUE),
			'id_shop' => array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => TRUE),
            'combination_value' => array('type' => self::TYPE_HTML, 'validate' => 'isString'),
			'encoded_value' => array('type' => self::TYPE_HTML, 'validate' => 'isString'),
        ),
    );
	
    public static function loadByIdCombination($id_ns_caisseconfig){
        $result = Db::getInstance()->getRow('
            SELECT *
            FROM `'._DB_PREFIX_.'ns_caisseconfig` sample
            WHERE sample.`id_ns_caisseconfig` = '.(int)$id_ns_caisseconfig
        );
        
        return new CombinationValue($result['id_ns_caisseconfig']);
    }
	
	
	public static function getItems($id_shop)
	{
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

		$sql = 'SELECT *
			FROM `'._DB_PREFIX_.'ns_caisseconfig` sample
            WHERE sample.`id_shop`='.(int)$id_shop.'
			ORDER  BY   sample.`id_ns_caisseconfig`  DESC 
			';

		return Db::getInstance()->executeS($sql);
	}
	
	
	
	public static function getDecliOne($id_shop)
	{
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

		$sql = 'SELECT  sample.`encoded_value`
			FROM `'._DB_PREFIX_.'ns_caisseconfig` sample
			WHERE sample.`id_shop` = '.(int)$id_shop.'
			';

		$results=Db::getInstance()->executeS($sql);
		
		 return array_column($results, 'encoded_value'); 


	}
	
	
	public static function getDecliTwo($id_shop)
	{
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

		$sql = 'SELECT  sample.`combination_id`
			FROM `'._DB_PREFIX_.'ns_caisseconfig` sample
			WHERE sample.`id_shop` = '.(int)$id_shop.'
			';

		$results=Db::getInstance()->executeS($sql);
		
		return array_column($results, 'combination_id');
		
		
	}
	
	
	
	
	  public  function doReplace($decli){		
		
		$id_shop = Context::getContext()->shop->id;
	    
		
        $decli_one =CombinationValue::getDecliOne($id_shop);
		
		$decli1 = array (  /*  liste de toutes les declinaisons et leur code caisse */
			'%20',
			'-',
			'%C2%A0',
        );
		
			
		
		foreach($decli_one  as $key=> $val){		  
	    $decli1[]=$val;
		/*rawurlencode(strtoupper(str_replace(' ', '', $val)));	*/	
		}
		
		
		$decliDva=array (
			'',
			'_',
			'',
			
			);
			
		$decli2 =array_merge($decliDva,CombinationValue::getDecliTwo($id_shop)); 	
        
		
	
			
		$decli3 = str_replace ($decli1,$decli2,$decli);
		
		return $decli3;	   
	   
   }  
   
   
   
   public static function verifyByNUmber($query)
	{		
		return Db::getInstance()->getRow('
			SELECT iv.`id_ns_caisseconfig`
			FROM `'._DB_PREFIX_.'ns_caisseconfig` iv	
			WHERE iv.`combination_id`='.(int)$query
		);
	}
	
	
	
	
}

